/**
 * Copyright (c) 2005, Freescale Semiconductor
 * Freescale Confidential Proprietary
 *
 * File name   : fir32.c
 * Project name: Mazatlan
 *
 * Author(s)   : Jaime Herrero
 *               Luis Reynoso
 * Department  : Guadalajara Applications Laboratory - RTAC Americas
 *
 * Description : fir32 Creation and Destruction 
 *               
 * History     :
 * 05/03/2005  : Created (A19257).
 */


#include "fir32.h"
#include "Memory\memalloc.h"

struct tFir32Struct* FIR32Create( Frac32* pCoef, uint16 u16Num){
    struct tFir32Struct* pFIR;
    
  	pFIR=(struct tFir32Struct*)memalloc(sizeof( struct tFir32Struct));
  	pFIR->pFirCoef=pCoef;
 	pFIR->iFirCoefCount=u16Num;
 	pFIR->pFirHistory=(Frac32*)memalloc((u16Num-1)*sizeof(Frac32));

    pFIR->iFirHistoryCount=0;

    return pFIR;    
}
	
void FIR32Destroy( struct tFir32Struct* pFIR){
    memfree (pFIR->pFirHistory);
    memfree (pFIR);
    return;
}
